package presentation.graph;

/**
 * @author Alberto Iachini
 */

import java.awt.geom.Point2D;

import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.VertexView;


public class StateVertexView extends VertexView {

	private static final long serialVersionUID = 348745467402455830L;
	public static transient StateVertexRenderer renderer;
	
	static
	{
		try
		{
			renderer = new StateVertexRenderer();
		}
		catch(Error e)
		{
			// No vertex renderer
		}
	}
	
	public StateVertexView()
	{
		super();
	}
	public StateVertexView(Object cell)
	{
		super(cell);
	}
	
	public CellViewRenderer getRenderer() {
		return renderer;
	}
	
	public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
		if (getRenderer() instanceof StateVertexRenderer)
			return ((StateVertexRenderer) getRenderer()).getPerimeterPoint(this,source, p);
		return super.getPerimeterPoint(edge, source, p);
	}

}
